<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;

class HelperServiceProvider extends ServiceProvider
{

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot(): void
    {
        $this->includeHelper();
    }

    public function includeHelper(){
        $rdi = new RecursiveDirectoryIterator(app_path("Helpers".DIRECTORY_SEPARATOR."Core".DIRECTORY_SEPARATOR. "Global"));
        $it = new RecursiveIteratorIterator($rdi);
        while ($it->valid()) {
            if (
                ! $it->isDot() &&
                $it->isFile() &&
                $it->isReadable() &&
                $it->current()->getExtension() === 'php' &&
                strpos($it->current()->getFilename(), 'Helper')
            ) {
                require $it->key();
            }
            $it->next();
        }
    }
}
