<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_recurrings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->constrained()->cascadeOnDelete();
            $table->foreignId('reference_invoice_id')->constrained('invoices')->cascadeOnDelete();
            $table->date('recurring_date');
            $table->timestamps();

            $table->index(['invoice_id', 'reference_invoice_id'], 'invoice_recurring_index');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_recurrings');
    }
};
