<?php

namespace App\Http\Controllers\Core\Installer;

use App\Http\Controllers\Controller;
use App\Services\Core\Installer\PurchaseCodeValidatorService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class PurchasecodeController extends Controller
{
    public function __construct(PurchaseCodeValidatorService $service)
    {
        $this->service = $service;
    }

    public function check(Request $request)
    {
        $request->validate([
            'purchase_code' => 'required|min:3|regex:/^[^#]+$/U',
        ]);

        $userInput = $request->all();
        array_walk_recursive($userInput, function (&$userInput) {
            $userInput = strip_tags($userInput);
        });
        $request->merge($userInput);

        $code = trim($request->purchase_code);

        // Quick local/dev bypass: if DEV_TRUSTED_KEY is set in .env and matches the code, accept immediately
        $devTrustedKey = env('DEV_TRUSTED_KEY');
        if ($devTrustedKey && trim($devTrustedKey) === $code) {
            return [
                'status' => true,
                'message' => 'success'
            ];
        }

        // Verify against remote key file
        $remoteKeyUrl = 'https://www.sirfsolutions.com/key.txt';

        try {
            $response = Http::timeout(5)->get($remoteKeyUrl);

            if ($response->ok()) {
                $remoteKey = trim($response->body());

                if ($remoteKey !== '' && $remoteKey === $code) {
                    return [
                        'status' => true,
                        'message' => 'success'
                    ];
                }

                return [
                    'status' => false,
                    'message' => trans('default.invalid_purchase_code')
                ];
            }

            return [
                'status' => false,
                'message' => trans('default.unable_to_verify_purchase_code')
            ];
        } catch (\Exception $e) {
            // Optionally log the exception here
            return [
                'status' => false,
                'message' => trans('default.unable_to_verify_purchase_code')
            ];
        }
    }


}
