<?php

namespace App\Http\Resources\Mobile\Profile;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProfileResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone_number' => $this->userProfile?->phone_number ?? null,
            'phone_country' => $this->userProfile?->phone_country ?? null,
            'address' => $this->userProfile?->address ?? null,
            'gender' => $this->userProfile?->gender ?? null,
            'profile_picture' => $this->profilePicture ? request()->root() . $this->profilePicture->path : null
        ];
    }
}
